/*
 * Decompiled with CFR 0.152.
 */
package net.famkruithof.logagent;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import net.famkruithof.logagent.LogConfigurator;
import net.famkruithof.logagent.LogTransformer;

public class LogAgent {
    private static final String CLASS = LogAgent.class.getName();
    private static Logger log = Logger.getLogger(CLASS);
    public static final String logPrefix = "logagent";

    public static void premain(String agentArgs, Instrumentation inst) {
        log.logp(Level.FINE, CLASS, "premain", "Called args : {0}.", agentArgs);
        LogConfigurator conf = new LogConfigurator(agentArgs);
        LogAgent.setupOutput(conf.getOutput());
        LogTransformer trans = new LogTransformer(conf, inst);
        inst.addTransformer(trans);
    }

    private static void setupOutput(String output) {
        if (output != null) {
            Logger logger = Logger.getLogger(logPrefix);
            try {
                FileHandler fh = new FileHandler(output);
                if (output.endsWith(".xml")) {
                    fh.setFormatter(new XMLFormatter());
                } else if (output.endsWith(".txt")) {
                    fh.setFormatter(new SimpleFormatter());
                }
                fh.setLevel(Level.ALL);
                logger.addHandler(fh);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            logger.setLevel(Level.ALL);
        }
    }
}

