/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.core.SortElementBuilder;

public abstract class SortJavaElement
implements Comparable {
    public static final int COMPILATION_UNIT = 1;
    public static final int TYPE = 2;
    public static final int CLASS = 4;
    public static final int INTERFACE = 8;
    public static final int FIELD = 16;
    public static final int INITIALIZER = 32;
    public static final int METHOD = 64;
    public static final int CONSTRUCTOR = 128;
    public static final int MULTIPLE_FIELD = 256;
    SortElementBuilder builder;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CORRESPONDING_ELEMENT = "corresponding_element";
    Hashtable options;
    protected int id;
    protected int sourceStart;
    protected int newSourceStart;
    protected int modifiers;
    protected String superclass;
    protected String[] superInterfaces;
    protected String[] parametersNames;
    protected String[] parametersTypes;
    protected String[] thrownExceptions;
    protected String returnType;
    protected String name;
    protected String type;
    protected int fieldCounter;
    protected SortElementBuilder.SortFieldDeclaration[] innerFields;
    protected ASTNode[] astNodes;
    protected int sourceEnd;
    protected int nameSourceStart;
    protected SortElementBuilder.SortElement[] children;
    protected int children_count;
    protected SortElementBuilder.SortElement firstChildBeforeSorting;
    protected SortElementBuilder.SortElement lastChildBeforeSorting;
    protected int declarationStart;
    protected int declarationSourceEnd;

    SortJavaElement(SortElementBuilder builder) {
        this.builder = builder;
        this.options = JavaCore.getOptions();
    }

    public int compareTo(Object o) {
        return this.builder.comparator.compare(this, o);
    }

    protected void addChild(SortElementBuilder.SortElement sortElement) {
        if (this.children_count == 0) {
            this.children = new SortElementBuilder.SortElement[3];
        } else if (this.children_count == this.children.length) {
            this.children = new SortElementBuilder.SortElement[this.children_count * 2];
            System.arraycopy(this.children, 0, this.children, 0, this.children_count);
        }
        this.children[this.children_count++] = sortElement;
    }

    protected void closeCollections() {
        int length = this.children_count;
        if (length != 0 && length != this.children.length) {
            this.children = new SortElementBuilder.SortElement[length];
            System.arraycopy(this.children, 0, this.children, 0, length);
        }
    }

    abstract void display(StringBuffer var1, int var2);

    protected void generateSource(StringBuffer buffer) {
        this.newSourceStart = buffer.length();
    }

    abstract void mapPositions();

    public String toString(int tab) {
        StringBuffer buffer = new StringBuffer();
        this.display(buffer, tab);
        if (this.children != null) {
            buffer.append(this.tab(tab)).append("CHILDREN ------------------------------" + LINE_SEPARATOR);
            int i = 0;
            while (i < this.children_count) {
                buffer.append(this.children[i].toString(tab + 1));
                buffer.append(LINE_SEPARATOR);
                ++i;
            }
        }
        return buffer.toString();
    }

    protected char[] tab(int tab) {
        char[] tabs = new char[tab];
        Arrays.fill(tabs, '\t');
        return tabs;
    }

    public String toString() {
        return this.toString(0);
    }

    protected void sort() {
        if (this.children != null) {
            this.firstChildBeforeSorting = this.children[0];
            this.lastChildBeforeSorting = this.children[this.children_count - 1];
            switch (this.id) {
                case 1: 
                case 6: 
                case 10: {
                    this.astNodes = this.convertChildren();
                    Arrays.sort(this.astNodes, this.builder.comparator);
                }
            }
            int i = 0;
            int max = this.children_count;
            while (i < max) {
                this.children[i].sort();
                ++i;
            }
        }
    }

    private ASTNode[] convertChildren() {
        ASTNode[] convertedNodes = new ASTNode[this.children_count];
        int i = 0;
        int max = this.children_count;
        while (i < max) {
            SortElementBuilder.SortElement currentElement = this.children[i];
            ASTNode newNode = currentElement.convert();
            newNode.setProperty(CORRESPONDING_ELEMENT, currentElement);
            convertedNodes[i] = newNode;
            ++i;
        }
        return convertedNodes;
    }
}

